/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.emulated;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class EmulatedReader
extends SerializeReader<MalformedDataException, EmulatedReader> {
    private static final Object SENTINEL_CLOSED = new Object();
    private Object[] stack = new Object[32];
    private int stackSize = 0;
    private String[] pathNames = new String[32];
    private int[] pathIndices = new int[32];

    public EmulatedReader(DataElement element) {
        this.stack[this.stackSize++] = element;
    }

    private void push(Object newTop) throws MalformedDataException {
        if (this.stackSize - 1 >= this.nestingLimit) {
            throw new MalformedDataException("Nesting limit " + this.nestingLimit + " reached" + this.locationString());
        }
        if (this.stackSize == this.stack.length) {
            int newLength = this.stackSize * 2;
            this.stack = Arrays.copyOf(this.stack, newLength);
            this.pathIndices = Arrays.copyOf(this.pathIndices, newLength);
            this.pathNames = Arrays.copyOf(this.pathNames, newLength);
        }
        this.stack[this.stackSize++] = newTop;
    }

    private Object peekStack() {
        return this.stack[this.stackSize - 1];
    }

    private Object popStack() {
        Object result = this.stack[--this.stackSize];
        this.stack[this.stackSize] = null;
        return result;
    }

    private void expect(Token expected) throws MalformedDataException {
        if (this.peek() != expected) {
            throw new IllegalStateException("Expected " + String.valueOf((Object)expected) + " but was " + String.valueOf((Object)this.peek()) + this.locationString());
        }
    }

    private String nextName(boolean skipName) throws MalformedDataException {
        this.expect(Token.NAME);
        Iterator i = (Iterator)this.peekStack();
        Map.Entry entry = (Map.Entry)i.next();
        String result = (String)entry.getKey();
        this.pathNames[this.stackSize - 1] = skipName ? "<skipped>" : result;
        this.push(entry.getValue());
        return result;
    }

    @Override
    public EmulatedReader beginArray() throws MalformedDataException {
        this.expect(Token.BEGIN_ARRAY);
        DataElement.Array array = (DataElement.Array)this.peekStack();
        this.push(array.elements().iterator());
        this.pathIndices[this.stackSize - 1] = 0;
        return this;
    }

    @Override
    public EmulatedReader endArray() throws MalformedDataException {
        this.expect(Token.END_ARRAY);
        this.popStack();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return this;
    }

    @Override
    public EmulatedReader beginObject() throws MalformedDataException {
        this.expect(Token.BEGIN_OBJECT);
        DataElement.Object object = (DataElement.Object)this.peekStack();
        this.push(object.members().entrySet().iterator());
        return this;
    }

    @Override
    public EmulatedReader endObject() throws MalformedDataException {
        this.expect(Token.END_OBJECT);
        this.pathNames[this.stackSize - 1] = null;
        this.popStack();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return this;
    }

    @Override
    public boolean hasNext() throws MalformedDataException {
        Token token = this.peek();
        return token != Token.END_OBJECT && token != Token.END_ARRAY && token != Token.END_DOCUMENT;
    }

    @Override
    public Token peek() throws MalformedDataException {
        if (this.stackSize == 0) {
            return Token.END_DOCUMENT;
        }
        Object o = this.peekStack();
        if (o instanceof Iterator) {
            Iterator iterator = (Iterator)o;
            boolean isObject = this.stack[this.stackSize - 2] instanceof DataElement.Object;
            if (iterator.hasNext()) {
                if (isObject) {
                    return Token.NAME;
                }
                this.push(iterator.next());
                return this.peek();
            }
            return isObject ? Token.END_OBJECT : Token.END_ARRAY;
        }
        if (o instanceof DataElement) {
            DataElement e;
            DataElement dataElement = e = (DataElement)o;
            Objects.requireNonNull(dataElement);
            DataElement dataElement2 = dataElement;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataElement.Object.class, DataElement.Array.class, DataElement.Primitive.class, DataElement.Null.class}, (Object)dataElement2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    DataElement.Object l = (DataElement.Object)dataElement2;
                    yield Token.BEGIN_OBJECT;
                }
                case 1 -> {
                    DataElement.Array l = (DataElement.Array)dataElement2;
                    yield Token.BEGIN_ARRAY;
                }
                case 2 -> {
                    DataElement.Primitive p;
                    DataElement.Primitive v2 = p = (DataElement.Primitive)dataElement2;
                    Objects.requireNonNull(v2);
                    DataElement.Primitive var12_10 = v2;
                    int var13_12 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataElement.Primitive.String.class, DataElement.Primitive.Boolean.class, DataElement.Primitive.Number.class}, (Object)var12_10, var13_12)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            DataElement.Primitive.String s = (DataElement.Primitive.String)var12_10;
                            yield Token.STRING;
                        }
                        case 1: {
                            DataElement.Primitive.Boolean b = (DataElement.Primitive.Boolean)var12_10;
                            yield Token.BOOLEAN;
                        }
                        case 2: 
                    }
                    DataElement.Primitive.Number n = (DataElement.Primitive.Number)var12_10;
                    yield Token.NUMBER;
                }
                case 3 -> {
                    DataElement.Null l = (DataElement.Null)dataElement2;
                    yield Token.NULL;
                }
            };
        }
        if (o == SENTINEL_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw new MalformedDataException("Custom JsonElement subclass " + o.getClass().getName() + " is not supported");
    }

    @Override
    public String nextName() throws MalformedDataException {
        return this.nextName(false);
    }

    @Override
    public String nextString() throws MalformedDataException {
        Token token = this.peek();
        if (token != Token.STRING && token != Token.NUMBER) {
            throw new IllegalStateException("Expected " + String.valueOf((Object)Token.STRING) + " but was " + String.valueOf((Object)token) + this.locationString());
        }
        String result = ((DataElement.Primitive)this.popStack()).asString();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result;
    }

    @Override
    public boolean nextBoolean() throws MalformedDataException {
        this.expect(Token.BOOLEAN);
        Object object = this.popStack();
        if (!(object instanceof DataElement.Primitive.Boolean)) {
            throw new IllegalStateException("Expected a boolean");
        }
        DataElement.Primitive.Boolean result = (DataElement.Primitive.Boolean)object;
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result.value();
    }

    @Override
    public void nextNull() throws MalformedDataException {
        this.expect(Token.NULL);
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public Number nextNumber() throws MalformedDataException {
        Token token = this.peek();
        if (token != Token.NUMBER && token != Token.STRING) {
            throw new IllegalStateException("Expected " + String.valueOf((Object)Token.NUMBER) + " but was " + String.valueOf((Object)token) + this.locationString());
        }
        Object object = this.popStack();
        if (!(object instanceof DataElement.Primitive.Number)) {
            throw new IllegalStateException("Expected a number");
        }
        DataElement.Primitive.Number result = (DataElement.Primitive.Number)object;
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result.value();
    }

    @Override
    public void skipValue() throws MalformedDataException {
        Token peeked = this.peek();
        switch (peeked) {
            case NAME: {
                String unused = this.nextName(true);
                break;
            }
            case END_ARRAY: {
                this.endArray();
                throw new IllegalStateException("Attempt to skip led outside its parent");
            }
            case END_OBJECT: {
                this.endObject();
                throw new IllegalStateException("Attempt to skip led outside its parent");
            }
            case END_DOCUMENT: {
                throw new IllegalStateException("Attempt to skip led outside the document");
            }
            default: {
                this.popStack();
                if (this.stackSize <= 0) break;
                int n = this.stackSize - 1;
                this.pathIndices[n] = this.pathIndices[n] + 1;
            }
        }
    }

    private String getPath(boolean usePreviousPath) {
        StringBuilder result = new StringBuilder().append('$');
        for (int i = 0; i < this.stackSize; ++i) {
            if (this.stack[i] instanceof DataElement.Array) {
                if (++i >= this.stackSize || !(this.stack[i] instanceof Iterator)) continue;
                int pathIndex = this.pathIndices[i];
                if (usePreviousPath && pathIndex > 0 && (i == this.stackSize - 1 || i == this.stackSize - 2)) {
                    --pathIndex;
                }
                result.append('[').append(pathIndex).append(']');
                continue;
            }
            if (!(this.stack[i] instanceof DataElement.Object) || ++i >= this.stackSize || !(this.stack[i] instanceof Iterator)) continue;
            result.append('.');
            if (this.pathNames[i] == null) continue;
            result.append(this.pathNames[i]);
        }
        return result.toString();
    }

    @Override
    public String getPath() {
        return this.getPath(false);
    }

    @Override
    public String getPreviousPath() {
        return this.getPath(true);
    }

    @Override
    public void close() {
        this.stack = new Object[]{SENTINEL_CLOSED};
        this.stackSize = 1;
    }

    @Override
    protected MalformedDataException createException(String message) {
        return new MalformedDataException(message + this.locationString());
    }
}

